'use strict';

/* Controllers */
var EstateCtrl = ['$scope', '$rootScope', '$location', '$route', '$window', 'FrontCreatorPlaces', function($scope, $rootScope, $location, $route, $window, FrontCreatorPlaces){
    var myPlayerName = "creator_estate";
    var myPlayer = _V_(myPlayerName);
    var addCuepointForVideojs = true;

    $rootScope.$on('Tutorial:open', function(event, type){
        myPlayer.pause();
    });

    $scope.CreatorStage = $route.current.locals.creatorStage;
    $scope.placesList = $route.current.locals.placesList;
    $scope.Company = $route.current.locals.company;
    $scope.usersList = {};//$route.current.locals.company.user_groups.users;

    $scope.currentPoint = {};
    $scope.checkedPlaces = new Array;
    $scope.indexTokenPart = 9;
    $scope.methodType = 'creator-estate';

    $scope.stageDone = false;

    $scope.places = [
        {id: 1, name: 'Biura', symbol:'OFFICE', checked: true, step_index: 2},
        {id: 2, name: 'Hale', symbol:'DEPOT', checked: false, step_index: 3},
        {id: 3, name: 'Magazyny', symbol:'STOCKROOM', checked: false, step_index: 4}
    ]

    $scope.init = function() {
        var state = $scope.Company.creator_state;
        if(state == 2 || state == 3 || state == 6 || state == 7){
            $scope.stageDone = true;
        }

        $('#wrap').removeClass('start-page');
        var partListPlayFalse = [2,3,4,5,6,7];
        angular.forEach($scope.CreatorStage.parts, function(part) {
            part.play = (in_array(part.index, partListPlayFalse)) ? false : true;
            part.hide = false;
        });

        var active = true;
        angular.forEach($scope.CreatorStage.steps, function(step) {
            step.active =  active;
            active = false;
        });

        angular.forEach($scope.placesList, function(places, symbol) {
            var checkedPlacesType = false;
            angular.forEach(places, function(place) {
                var checked = false;
                $scope.Company.places.forEach(function(companyPlace) {
                    if(companyPlace.item_id == place.id) {
                        checked = true;
                        checkedPlacesType = true;
                    }
                });
                place.checked = checked;
                if(checked) {
                    $scope.checkedPlaces.push(place);
                }
            });
            for(var i=0;i<$scope.places.length;i++) {
                if($scope.places[i].symbol == symbol){
                    $scope.places[i].checked = checkedPlacesType;
                    angular.forEach($scope.CreatorStage.parts, function(part){
/*                        if(part.index == $scope.places[i].step_index) {
                            part.play = $scope.places[i].checked;
                        }*/
                    });
                }
                if ($scope.places[i].symbol == 'OFFICE') {
                    $scope.places[i].checked = true;
                }
            }
        });

        angular.forEach($scope.Company.user_groups.users, function(user) {
            user.fullName = user.name+' '+user.surname;
            user.token = '';
            $scope.usersList[user.id] = user;
        });

//        angular.forEach($scope.Company.places, function(place) {
//            place.kw = $scope.createNumberKW();
//        });

        $scope.addCuepointForVideojs();
    }

    $scope._filterOffDep = function(place){
        if(place.item.type.symbol == "OFFICE" || place.item.type.symbol == "DEPOT" || place.item.type.symbol == "STOCKROOM"){
            return true;
        }else{
            return false;
        }
    }

    $scope.addCuepointForVideojs = function(){
        if(addCuepointForVideojs) {
            videojs(myPlayerName).ready(function(){
                var $this = this;
                $this.cuepoints();
                angular.forEach($scope.CreatorStage.parts, function(part){
                    $this.addCuepoint({
                        namespace: "logger",
                        start: part.end,
                        end: part.end + 0.3,
                        onStart: function(params){
                            if(params.error){
                            }else{
                                myPlayer.pause();
                                hiddenControlVideo();
                                $rootScope.$broadcast('DialogPanelEstate:show', part);
                                $(".nano").nanoScroller();
                            }
                        },
                        onEnd: function(params){
                            myPlayer.play();
                        },
                        params: {error: false}
                    });
                });
            });
            addCuepointForVideojs = false;
        }
        myPlayer.ready(function(){
            this.on("ended", function(){
                $location.path('/creator/bank');
            });
        });
//        $(".nano").nanoScroller();
    }

    $scope.resetVideo = function(){
        myPlayer.currentTime(0);
        $scope.currentPoint = {};
        $scope.showValidation = false;
        showControlVideo();
        myPlayer.play();
    }

    $scope.$on('DialogPanelEstate:show', function(event, part){
        $scope.currentPoint = part;
        $scope.$apply();
        if($scope.currentPoint.index == $scope.indexTokenPart ) {
            $scope.broadcast();
        }
    });

    $scope.$on('Tokens:closeSubmitTokensModal', function(event,methodType){
        if(methodType == $scope.methodType) {
            $scope.playVideo();
        }
    });

    $scope.submitForm = function(form,setIsDone) {
        if (form == undefined || form.$valid) {
            $scope.playVideo(setIsDone);
        } else {
            $scope.showValidation = form.$invalid;
        }
    }

    $scope.submitFormPlacesType = function(form) {
        $scope.showParts();
        if (form == undefined || form.$valid) {
            angular.forEach($scope.places,function(place){
                if(!place.checked){
                    $scope.removeCompanyPlacesForSymbolType(place.symbol);
                }
            });
            $scope.savePlaces();
//            FrontCreatorPlaces.saveChecked({places: $scope.Company.places},function(data){
//                $scope.Company = data;
//                $scope.playVideo();
//            });
        } else {
            $scope.showValidation = form.$invalid;
        }
    }

    $scope.submitFormPlaces = function(form) {
        if (form == undefined || form.$valid) {
            $scope.savePlaces();
//            FrontCreatorPlaces.saveChecked({places: $scope.Company.places},function(data){
//                $scope.Company = data;
//                $scope.playVideo();
//            });
        } else {
            $scope.showValidation = form.$invalid;
        }
    }

    $scope.savePlaces = function()
    {
        FrontCreatorPlaces.saveChecked({during_creator: true, places: $scope.Company.places},
            function(data){
                $scope.Company = data;
                $scope.playVideo();
            },
            function(data){
                var message = {
                    title: "Błąd kreatora."
                    ,msg: data.data.message
                }

                $rootScope.$broadcast('Message:addMsg', message);
                setTimeout(function(){
                    $rootScope.$broadcast('Message:delMsg', message);
                    setTimeout(function(){
                        $window.location.reload();
//                        $location.path('/boardControlPanel/personnel');
                    }, 500);
                }, 4000);
            });
    }

    $scope.playVideo = function(setIsDone){
        if($scope.currentPoint.step_index > 0){
            angular.forEach($scope.CreatorStage.steps, function(step){
                if(step.index == $scope.currentPoint.step_index){
                    if(typeof setIsDone == "undefined" || setIsDone) {
                        step.done = true;
                    }
                    step.active = true;
                } else {
                    step.active = false;
                }
            });
        }

        var nextPoint = getNextPoint($scope.currentPoint);
        if(nextPoint.hasOwnProperty('id') && !nextPoint.play) {
            myPlayer.currentTime(nextPoint.end+0.3);
            $scope.currentPoint = nextPoint;
            $scope.submitForm(undefined,false);
        }

        $scope.currentPoint = {};
        $scope.showValidation = false;
        showControlVideo();
        myPlayer.play();
    }

    $scope.showPanel = function($index){
        return ($scope.currentPoint.hasOwnProperty('id') && ($index == $scope.currentPoint.index));
    }

    $scope.isSelectedPanel = function(){
        return ($scope.currentPoint.hasOwnProperty('id'));
    }

    $scope.checkLocalType = function(localType) {
        if (localType.symbol == 'OFFICE') {
            localType.checked = true;
        }else{
            localType.checked = !localType.checked;
        }
    }

    $scope.showParts = function() {
        for (var i = 1; i < 6; i++){
            $scope.CreatorStage.parts[i].play = false;
        }

        var checkedPlaces = $scope.places.filter(function(place) {return place.checked == true;});
        
        if(checkedPlaces.length == 1){
            angular.forEach($scope.CreatorStage.parts, function(part){
                if(part.index == checkedPlaces[0].step_index) {
                    part.play = checkedPlaces[0].checked;
                }
            });
        }else if(checkedPlaces.length == 3){
            $scope.CreatorStage.parts[6].play = true;
        }else if(checkedPlaces.length == 2){
            var depot = false;
            var stockroom = false;

            angular.forEach(checkedPlaces, function(place){
                if(place.symbol == "DEPOT") {
                    depot = true;
                }else if(place.symbol == "STOCKROOM"){
                    stockroom = true;
                }
            });

            if(depot){
                $scope.CreatorStage.parts[4].play = true;
            }else if(stockroom){
                $scope.CreatorStage.parts[5].play = true;
            }
        }

    }

    $scope.checkPlace = function(place) {
        place.checked = !place.checked;
        if(place.checked) {
            $scope.Company.places.push({'item':place,'item_id':place.id});
        } else {
            var index=0;
            while(index < $scope.Company.places.length){
                if($scope.Company.places[index].item_id == place.id) {
                    angular.forEach($scope.placesList[place.type.symbol],function(placeEl){
                        if(placeEl.id == $scope.Company.places[index].id){
                            placeEl.checked = false;
                        }
                    });
                    $scope.Company.places.splice(index,1);
                } else {
                    index++;
                }
            }
        }
    }

    $scope.removeCompanyPlacesForSymbolType = function(symbol){
        var index=0;
        while(index < $scope.Company.places.length){
            if($scope.Company.places[index].item.type.symbol == symbol) {
                angular.forEach($scope.placesList[symbol],function(place){
                    if(place.id == $scope.Company.places[index].item_id){
                        place.checked = false;
                    }
                });
                $scope.Company.places.splice(index,1);
            } else {
                index++;
            }
        }
    }

    $scope.broadcast = function() {
        var params = {};
        params.title = 'Podpisanie umowy najmu';
        params.tokensConfirmsMessage = 'creator,'+$scope.CreatorStage.symbol;
        params.typeSubmitToken = 'REPRESENTATION';

        $rootScope.$broadcast('Tokens:openSubmitTokensModal',$scope.Company, params, $scope.methodType);
    }

    $scope.createNumberKW = function() {
        return 'RZ1Z/'+(Math.floor(Math.random()*900001) + 1000000)+'/'+(Math.floor(Math.random()*10));
    }

    $scope.getChef = function() {
        var user = $scope.Company.user_groups.users.filter(function(user) {
            return (user.company_roles.filter(function(role) {return role.symbol == 'C';}).length > 0);
        });
        return (user[0] != undefined) ? user[0].fullName : false;
    }

    $scope.nameNumber = function(number) {
        var jednosci = ["", " jeden", " dwa", " trzy", " cztery", " pięć", " sześć", " siedem", " osiem", " dziewięć"];
        var nascie = ["", " jedenaście", " dwanaście", " trzynaście", " czternaście", " piętnaście", " szesnaście", " siedemnaście", " osiemnaście", " dziewietnaście"];
        var dziesiatki = ["", " dziesięć", " dwadzieścia", " trzydzieści", " czterdzieści", " pięćdziesiąt", " sześćdziesiąt", " siedemdziesiąt", " osiemdziesiąt", " dziewięćdziesiąt"];
        var setki = ["", " sto", " dwieście", " trzysta", " czterysta", " pięćset", " sześćset", " siedemset", " osiemset", " dziewięćset"];
        var grupy = [["" ,"" ,""],[" tysiąc" ," tysiące" ," tysięcy"],[" milion" ," miliony" ," milionów"],[" miliard"," miliardy"," miliardów"],[" bilion" ," biliony" ," bilionów"],[" biliard"," biliardy"," biliardów"],[" trylion"," tryliony"," tryliardów"]];

        if (!isNaN(number)){
            var wynik = '';
            var znak = '';
            if (number == 0) wynik = "zero";
            if (number < 0) {
                znak = "minus";
                number = number;
            }

            var g = 0;
            while (number > 0) {
                var s = Math.floor((number % 1000)/100);
                var n = 0;
                var d = Math.floor((number % 100)/10);
                var j = Math.floor(number % 10);
                if (d == 1 && j>0) {
                    n = j;
                    d = 0;
                    j = 0;
                }

                var k = 2;
                if (j == 1 && s+d+n == 0)
                    k = 0;
                if (j == 2 || j == 3 || j == 4)
                    k = 1;
                if (s+d+n+j > 0)
                    wynik = setki[s]+dziesiatki[d]+nascie[n]+jednosci[j]+grupy[g][k]+wynik;

                g++;
                number = Math.floor(number/1000);
            }
        }
        return wynik;
    }

    function getNextPoint(point) {
        if(!point) return $scope.CreatorStage.parts[0];
        var nextPoint = {};
        angular.forEach($scope.CreatorStage.parts, function(part, index){
            if(part.id == point.id) {
                nextPoint = ($scope.CreatorStage.parts[index+1] === undefined) ? {} : $scope.CreatorStage.parts[index+1];
            }
        });
        return nextPoint;
    }

    function hiddenControlVideo() {
        $($('.vjs-play-control').first()).css("visibility","hidden");
        $($('.vjs-progress-control').first()).css("visibility","hidden");
    }

    function showControlVideo() {
        $($('.vjs-play-control').first()).css("visibility","");
        $($('.vjs-progress-control').first()).css("visibility","");
    }

    function in_array(needle, haystack) {
        for(var i in haystack) {
            if(haystack[i] == needle) return true;
        }
        return false;
    }
}]

EstateCtrl.getCreatorStage = function($q, $route, $rootScope, FrontCreatorStage){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorStage.get({symbol: "ESTATE"},function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}

EstateCtrl.getRandomPlaces = function($q, $route, $rootScope, FrontCreatorPlaces){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorPlaces.getRandom(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}